<?php
// bot1.php - ZOOMIER TECH | IP BOT - Scanner IPTV com sistema Pix, aprovação ADM e 3 testes grátis

$token = "7740757433:AAFP4ORToEGI1XTGewK1vEVltF1iQmDN1z0";
$admin_id = 7937526615;
define("API", "https://api.telegram.org/bot$token/");
define("M3U_CANAIS", "https://xuis.n-1.fun/canais.m3u");
define("M3U_LOGOS", "https://xuis.n-1.fun/logos.m3u");
define("PIX_CHAVE", "kodplay.canais@gmail.com");
define("USUARIOS_DB", __DIR__ . "/usuarios.json");
define("TMP_DIR", __DIR__ . "/tmp/");

function limparTemporarios($dir, $tempo_max = 3600) {
    foreach (glob("$dir/*") as $file) {
        if (is_file($file) && time() - filemtime($file) > $tempo_max) {
            @unlink($file);
        }
    }
}
limparTemporarios(TMP_DIR);

function extrairQualidade($url) {
    $output = shell_exec("ffprobe -v error -select_streams v:0 -show_entries stream=width,height,bit_rate -of default=noprint_wrappers=1 \"$url\"");
    preg_match('/width=(\d+)/', $output, $w);
    preg_match('/height=(\d+)/', $output, $h);
    preg_match('/bit_rate=(\d+)/', $output, $b);
    $resolucao = isset($w[1], $h[1]) ? "{$h[1]}p" : "Desconhecida";
    $bitrate = isset($b[1]) ? round($b[1] / 1000) . " kbps" : "Desconhecido";
    return "$resolucao | $bitrate";
}

function carregarUsuarios() {
    if (!file_exists(USUARIOS_DB)) return [];
    return json_decode(file_get_contents(USUARIOS_DB), true);
}

function salvarUsuarios($usuarios) {
    file_put_contents(USUARIOS_DB, json_encode($usuarios));
}

function enviarMensagem($chat_id, $texto, $botoes = null, $parse_mode = 'HTML') {
    $params = [
        'chat_id' => $chat_id,
        'text' => $texto,
        'parse_mode' => $parse_mode,
    ];
    if ($botoes !== null) {
        $params['reply_markup'] = json_encode(['inline_keyboard' => $botoes]);
    }
    file_get_contents(API . "sendMessage?" . http_build_query($params));
}

function enviarVideo($chat_id, $file_path, $caption = '', $botoes = null) {
    $post_fields = [
        'chat_id' => $chat_id,
        'video' => new CURLFile($file_path),
        'caption' => $caption,
        'parse_mode' => 'HTML',
    ];
    if ($botoes !== null) {
        $post_fields['reply_markup'] = json_encode(['inline_keyboard' => $botoes]);
    }
    $ch = curl_init(API . "sendVideo");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

function baixarUrl($url) {
    if (ini_get('allow_url_fopen')) return @file_get_contents($url);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}

function extrairMetadadosLinha($linha) {
    preg_match('/tvg-logo="([^"]*)".*group-title="([^"]*)",\s*(.*)/i', $linha, $m);
    return [
        'logo' => $m[1] ?? 'https://i.imgur.com/qz6sV6V.png',
        'grupo' => $m[2] ?? 'Sem Grupo',
        'nome' => $m[3] ?? 'Canal Desconhecido',
    ];
}

function processarM3U($url) {
    $raw = baixarUrl($url);
    if (!$raw) return [];
    $linhas = explode("\n", $raw);
    $metadados = [];
    for ($i = 0; $i < count($linhas); $i++) {
        if (strpos($linhas[$i], '#EXTINF') !== false) {
            $meta = extrairMetadadosLinha($linhas[$i]);
            $url_canal = trim($linhas[$i + 1] ?? '');
            if (filter_var($url_canal, FILTER_VALIDATE_URL)) {
                $metadados[$url_canal] = $meta;
            }
        }
    }
    return $metadados;
}

function buscarMetadadosPorNome($nome, $lista) {
    $nome = mb_strtolower(trim($nome));
    $nomes = explode(" ", $nome);
    $chaves = [];
    if (count($nomes) > 1) $chaves[] = $nomes[0] . ' ' . $nomes[1];
    $chaves[] = $nomes[0];
    foreach ($lista as $url => $meta) {
        $meta_nome = mb_strtolower($meta['nome']);
        foreach ($chaves as $chave) {
            if (str_contains($meta_nome, $chave)) {
                return $meta;
            }
        }
    }
    return null;
}

function escanearCanais($ip, $canais_m3u, $logos_m3u) {
    $portas = range(13000, 20000);
    $encontrados = [];
    foreach ($portas as $porta) {
        $url = "http://$ip:$porta";
        $headers = @get_headers($url);
        if ($headers && strpos($headers[0], '200') !== false) {
            $meta_canal = $canais_m3u[$url] ?? null;
            $nome_canal = $meta_canal['nome'] ?? "Canal $porta";
            $meta_logo = buscarMetadadosPorNome($nome_canal, $logos_m3u);
            if ($meta_logo === null) $meta_logo = ['logo'=>'https://i.imgur.com/qz6sV6V.png','grupo'=>'Sem Grupo'];
            $encontrados[] = [
                'nome' => $nome_canal,
                'grupo' => $meta_logo['grupo'],
                'logo' => $meta_logo['logo'],
                'url' => $url,
            ];
        }
    }
    return $encontrados;
}

function gravarVideo10s($url, $ip) {
    if (!is_dir(TMP_DIR)) mkdir(TMP_DIR, 0777, true);
    $file = TMP_DIR . "gravado_{$ip}_" . time() . ".mp4";
    $cmd = "ffmpeg -y -i \"$url\" -t 10 -c copy \"$file\" 2>&1";
    exec($cmd, $output, $ret);
    if ($ret === 0 && file_exists($file)) return $file;
    return false;
}

// --- INÍCIO DO BOT ---
$update = json_decode(file_get_contents("php://input"), true);
$message = $update["message"] ?? null;
$callback = $update["callback_query"] ?? null;
$usuarios = carregarUsuarios();

if ($message) {
    $chat_id = $message["chat"]["id"];
    $user_id = $message["from"]["id"];
    $text = $message["text"] ?? "";

    // Criar usuário com 3 testes grátis
    $usuarios[$user_id] = $usuarios[$user_id] ?? ['aprovado'=>false, 'estado'=>null, 'ultimo_ip'=>null, 'testes'=>0];
    salvarUsuarios($usuarios);

    // Comando de alerta do admin
    if ($user_id == $admin_id && strpos($text, "/alerta ") === 0) {
        $mensagem = trim(substr($text, 8));
        $enviados = 0;
        foreach ($usuarios as $uid => $dados) {
            if ($dados['aprovado']) {
                enviarMensagem($uid, "📢 <b>Alerta do ZOOMIER TECH</b>\n\n$mensagem");
                $enviados++;
            }
        }
        enviarMensagem($chat_id, "✅ Alerta enviado para $enviados usuários aprovados.");
        exit;
    }

    // Recebendo comprovante
    if (isset($message["photo"])) {
        if (!$usuarios[$user_id]['aprovado']) {
            enviarMensagem($chat_id, "📨 Comprovante recebido! Aguarde aprovação.");
            enviarMensagem($admin_id, "⚠️ Novo comprovante de <code>$user_id</code>", [
                [["text"=>"✅ Aprovar","callback_data"=>"aprovar:$user_id"],["text"=>"❌ Rejeitar","callback_data"=>"rejeitar:$user_id"]]
            ]);
        } else {
            enviarMensagem($chat_id, "Você já está aprovado.");
        }
        exit;
    }

    // Estado de envio do IP
    switch ($usuarios[$user_id]['estado']) {
        case 'aguardando_ip':
            if (filter_var($text, FILTER_VALIDATE_IP)) {
                if (!$usuarios[$user_id]['aprovado'] && $usuarios[$user_id]['testes'] >= 3) {
                    enviarMensagem($chat_id, "🔒 Você já usou os 3 testes grátis. Pague R$25 para liberar acesso completo.\n\nPIX: <code>".PIX_CHAVE."</code>");
                    exit;
                }

                enviarMensagem($chat_id, "⏳ Escaneando IP: <b>$text</b>");
                $usuarios[$user_id]['estado'] = 'escaneando';
                $usuarios[$user_id]['ultimo_ip'] = $text;
                salvarUsuarios($usuarios);

                $canais_m3u = processarM3U(M3U_CANAIS);
                $logos_m3u = processarM3U(M3U_LOGOS);
                $resultados = escanearCanais($text, $canais_m3u, $logos_m3u);

                if (count($resultados) == 0) {
                    enviarMensagem($chat_id, "Nenhum canal encontrado nesse IP.");
                } else {
                    foreach ($resultados as $canal) {
                        $qualidade = extrairQualidade($canal['url']);
                        $texto = "<b>Nome:</b> {$canal['nome']}\n<b>Categoria:</b> {$canal['grupo']}\n<b>Qualidade:</b> $qualidade\n<b>Link:</b> {$canal['url']}";
                        enviarMensagem($chat_id, $texto, [
                            [["text"=>"📋 Copiar Link","url"=>$canal['url']]]
                        ]);
                        $video = gravarVideo10s($canal['url'], $text);
                        if ($video !== false) {
                            enviarVideo($chat_id, $video, "🎬 Preview: {$canal['nome']}");
                            @unlink($video);
                        }
                    }
                }

                if (!$usuarios[$user_id]['aprovado']) {
                    $usuarios[$user_id]['testes']++;
                    $restantes = max(0, 3 - $usuarios[$user_id]['testes']);
                    if ($restantes > 0) {
                        enviarMensagem($chat_id, "🎁 Teste gratuito usado. Restam <b>$restantes</b>.");
                    } else {
                        enviarMensagem($chat_id, "⚠️ Acabaram seus testes gratuitos. Envie o comprovante Pix para continuar.");
                    }
                }

                $usuarios[$user_id]['estado'] = null;
                salvarUsuarios($usuarios);
            } else {
                enviarMensagem($chat_id, "❌ IP inválido. Envie um IP válido.");
            }
            break;

        default:
            $testes = $usuarios[$user_id]['testes'];
            $resta = max(0, 3 - $testes);
            $msg = "🚀 Bem-vindo ao ZOOMIER TECH | IP BOT\n\n";
            if (!$usuarios[$user_id]['aprovado']) {
                $msg .= "🎁 Você tem direito a <b>3 testes grátis</b>.\n";
                $msg .= "📊 Usados: <b>$testes</b> | Restam: <b>$resta</b>\n";
            }
            enviarMensagem($chat_id, $msg, [
                [["text"=>"🔍 Escanear IP", "callback_data"=>"scan"]],
                [["text"=>"💳 Pagar R$25 via Pix", "callback_data"=>"pix"]],
            ]);
            break;
    }
    exit;
}

if ($callback) {
    $chat_id = $callback["message"]["chat"]["id"];
    $user_id = $callback["from"]["id"];
    $data = $callback["data"];
    $usuarios[$user_id] = $usuarios[$user_id] ?? ['aprovado'=>false, 'estado'=>null, 'ultimo_ip'=>null, 'testes'=>0];

    if (preg_match('/^(aprovar|rejeitar):(\d+)$/', $data, $m)) {
        if ($user_id != $admin_id) exit;
        $acao = $m[1];
        $target_id = $m[2];
        if (!isset($usuarios[$target_id])) exit;
        if ($acao == 'aprovar') {
            $usuarios[$target_id]['aprovado'] = true;
            enviarMensagem($target_id, "✅ Seu acesso foi aprovado!");
            enviarMensagem($chat_id, "✅ Usuário $target_id aprovado.");
        } else {
            $usuarios[$target_id]['aprovado'] = false;
            enviarMensagem($target_id, "🚫 Seu acesso foi rejeitado.");
            enviarMensagem($chat_id, "❌ Usuário $target_id rejeitado.");
        }
        salvarUsuarios($usuarios);
        exit;
    }

    if ($data === "scan") {
        if (!$usuarios[$user_id]['aprovado'] && $usuarios[$user_id]['testes'] >= 3) {
            enviarMensagem($chat_id, "🔒 Você já usou os 3 testes grátis. Para continuar, pague R$25 via Pix:\n\n<code>".PIX_CHAVE."</code>");
            exit;
        }
        $usuarios[$user_id]['estado'] = 'aguardando_ip';
        salvarUsuarios($usuarios);
        enviarMensagem($chat_id, "🔍 Envie o IP para iniciar a varredura (13000-20000).");
        exit;
    }

    if ($data === "pix") {
        enviarMensagem($chat_id,
            "💳 Para liberar o acesso, pague <b>R$25</b> via Pix:\n\n".
            "<code>".PIX_CHAVE."</code>\n\n".
            "Depois envie o comprovante aqui no chat.");
        exit;
    }
}